// page_patch.js (injected into page context)

// 1) Kill Presentation API (sites can't auto-init mirroring)
try {
  Object.defineProperty(navigator, 'presentation', {
    value: undefined,
    configurable: true
  });
  window.PresentationRequest = undefined;
} catch (_) {}

// 2) Best-effort: make Cast sender API unavailable
try {
  // Some sites check window.chrome && chrome.cast
  // We redefine 'chrome' getter to return undefined
  Object.defineProperty(window, 'chrome', {
    get() { return undefined; },
    set(_) {},
    configurable: true
  });
  window.cast = undefined;
  window.__onGCastApiAvailable = undefined;
} catch (_) {}

// 3) Defensive: stop early-loaded cast buttons
(function() {
  const style = document.createElement('style');
  style.textContent = `
    button[is="google-cast-button"], google-cast-button {
      display: none !important;
      visibility: hidden !important;
      pointer-events: none !important;
    }
  `;
  (document.head || document.documentElement).appendChild(style);
})();
